// config: norepeat

#include "GetObjects.js"
#include "GetOrientation.js"

function DoOrient()
{
	var objectpicker = moi.ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	
	// Initialize 'Align to object' and 'Flip aligned z axis' controls for the base pick.
	// By default the base direction is flipped.
	var AlignBaseToObjects = true;
	var AlignBaseFlipZ = true;
	try { AlignBaseToObjects = moi.command.getOption( 'AlignBaseToObjects' ); } catch(e) {}
	try { AlignBaseFlipZ = moi.command.getOption( 'AlignBaseFlipZ' ); } catch(e) {}
	moi.ui.commandUI.FlipAlignedZAxis.value = AlignBaseFlipZ;
	moi.ui.commandUI.OrientationPickerAlignToObjects.value = AlignBaseToObjects;
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'BasePrompt1' );
	moi.ui.showUI( 'OrientOptions' );
	moi.ui.endUIUpdate();

	// Get the base frame.	
	var picker = moi.ui.createOrientationPicker();
	picker.noDefaultFrame = true;
	if ( !GetOrientation( picker, 'BasePrompt1', 'BasePrompt2' ) )
		return;
		
	var baseframe = picker.frame;

	// Set up the orient factory, with the objects and the base frame in it.
	var factory = moi.command.createFactory( 'orient' );
	factory.setInput( 0, objects );
	factory.setInput( 1, baseframe );

	// Save 'Align to object' and 'Flip aligned z axis' values for the base pick.
	moi.command.setOption( 'AlignBaseToObjects', moi.ui.commandUI.OrientationPickerAlignToObjects.value );
	moi.command.setOption( 'AlignBaseFlipZ', moi.ui.commandUI.FlipAlignedZAxis.value );

	// Initialize 'Align to object' and 'Flip aligned z axis' controls for the target pick.
	var AlignTargetToObjects = true;
	var AlignTargetFlipZ = false;
	try { AlignTargetToObjects = moi.command.getOption( 'AlignTargetToObjects' ); } catch(e) {}
	try { AlignTargetFlipZ = moi.command.getOption( 'AlignTargetFlipZ' ); } catch(e) {}
	moi.ui.commandUI.FlipAlignedZAxis.value = AlignTargetFlipZ;	
	moi.ui.commandUI.OrientationPickerAlignToObjects.value = AlignTargetToObjects;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'BasePrompt2' );
	moi.ui.showUI( 'TargetPrompt1' );
	moi.ui.showUI( 'OrientationPickerAlignToObjects' );
	
	if ( AlignTargetToObjects )
		moi.ui.showUI( 'FlipAlignedZAxis' );
	
	moi.ui.showUI( 'AlignSeparatorLine' );		
	moi.ui.endUIUpdate();
	
	// Loop on getting the target frame so we can optionally drop copies.
	while ( 1 )
	{
		// Get the target frame.
		picker.reset();
		picker.clearBindings();
		picker.bindResultFrame( factory.getInput(2) );
		var result = GetOrientation( picker, 'TargetPrompt1', 'TargetPrompt2' );

		// Save 'Align to object' and 'Flip aligned z axis' values for the target pick.
		moi.command.setOption( 'AlignTargetToObjects', moi.ui.commandUI.OrientationPickerAlignToObjects.value );
		moi.command.setOption( 'AlignTargetFlipZ', moi.ui.commandUI.FlipAlignedZAxis.value );

		// Bail out if canceled.		
		if ( !result )
			return;

		// Enable dropping a copy if the checkbox is set or if Ctrl was held down.			
		var makecopies = moi.ui.commandUI.MakeCopies.value || picker.controlDown;
		
		// If not making copies, then finish now.	
		if ( !makecopies )
		{
			factory.commit();
			break;
		}
		
		// Otherwise, drop a copy and keep going.

		// Set up a fresh factory for the next one.
		var newfactory = moi.command.createFactory( 'orient' );
		newfactory.setInput( 0, objects );
		newfactory.setInput( 1, baseframe );
		newfactory.setInput( 2, picker.frame );

		// Set the make copies option on the current factory.
		factory.setInput( 3, true );
		
		// Commit the existing factory and hide the input objects on the new one in one batch to avoid flickering.
		factory.commitAndPrepOther( newfactory );

		// The new factory now becomes the current one.		
		factory = newfactory;
	}
}

DoOrient();
